using System;

namespace Server.Items
{
	public abstract class BaseSilkOuterLegs : BaseClothing
	{
		public BaseSilkOuterLegs( int itemID ) : this( itemID, 0 )
		{
		}

		public BaseSilkOuterLegs( int itemID, int hue ) : base( itemID, Layer.OuterLegs, hue )
		{
		}

        public BaseSilkOuterLegs(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x230C, 0x230B )]
	public class SilkSarong : BaseSilkOuterLegs
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 2; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 3; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkSarong() : this( 0 )
		{
		}

		[Constructable]
		public SilkSarong( int hue ) : base( 0x230C, hue )
		{
			Weight = 3.0;
            Name = "Silk Sarong";
		}

        public SilkSarong(Serial serial)
            : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			if ( Weight == 4.0 )
				Weight = 3.0;
		}
	}

	[Flipable( 0x1516, 0x1531 )]
	public class SilkSkirt : BaseSilkOuterLegs
	{
        public override int BasePhysicalResistance { get { return 2; } }
        public override int BaseFireResistance { get { return 2; } }
        public override int BaseColdResistance { get { return 3; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkSkirt() : this( 0 )
		{
		}

		[Constructable]
		public SilkSkirt( int hue ) : base( 0x1516, hue )
		{
			Weight = 4.0;
            Name = "Silk Skirt";
		}

		public SilkSkirt( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x1537, 0x1538 )]
	public class SilkKilt : BaseSilkOuterLegs
	{
        public override int BasePhysicalResistance { get { return 0; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 0; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkKilt() : this( 0 )
		{
		}

		[Constructable]
		public SilkKilt( int hue ) : base( 0x1537, hue )
		{
			Weight = 2.0;
            Name = "Silk Kilt";
		}

		public SilkKilt( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}

	[Flipable( 0x279A, 0x27E5 )]
	public class SilkHakama : BaseSilkOuterLegs
	{
        public override int BasePhysicalResistance { get { return 1; } }
        public override int BaseFireResistance { get { return 1; } }
        public override int BaseColdResistance { get { return 1; } }
        public override int BasePoisonResistance { get { return 4; } }
        public override int BaseEnergyResistance { get { return 1; } }

        public override int InitMinHits { get { return 10; } }
        public override int InitMaxHits { get { return 20; } }

		[Constructable]
		public SilkHakama() : this( 0 )
		{
		}

		[Constructable]
		public SilkHakama( int hue ) : base( 0x279A, hue )
		{
			Weight = 2.0;
            Name = "Silk Hakama";
		}

		public SilkHakama( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}